﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

namespace Kinematics
{
    class Program
    {
        static void Main(string[] args)
        {
            KinematicsObject kObj = new KinematicsObject();
            bool display = false;
            int selection = -1;
            while (selection != 5)
            {
                selection = ShowMenu();
                switch (selection)
                {
                    case 1:
                        kObj = new KinematicsObject();
                        double[] thetas = new double[Constants.PUMA_JOINTS];
                        Console.Clear();
                        Console.WriteLine("For Puma 560 Robot values of " + Convert.ToChar(945) + ",a, and d of A1,A2,..,A6 were uploaded\n Please Enter @1,@2,...,@6 Values in degrees");
                        for (int i = 0; i < Constants.PUMA_JOINTS; i++)
                        {
                            thetas[i] = GetDouble("Enter the value for @" + (i+1) + ": ");
                        }
                        kObj.UploadPuma(thetas);
                        display = true;
                        break;
                    case 2:
                        int size = 1;
                        Console.Clear();
                        while (size < 2 || size > 10)
                        {
                            Console.Write("Enter the number of joints: ");
                            Int32.TryParse(Console.ReadLine(), out size);
                            if (size < 2 || size > 10)
                                Console.WriteLine("Invalid size, the size should be an integer between 2 and 10");
                        }
                        kObj = new KinematicsObject(false, size);
                        List<JointObject> joints = new List<JointObject>();
                        for (int i = 0; i < kObj.NumberOfJoints; i++)
                        {
                            joints.Add(GetDHPatameter(i+1));
                        }
                        kObj.UploadCustom(joints);
                        display = true;
                        break;
                    case 3:
                        if (display)
                        {
                            Console.Clear();
                            for (int k = 0; k < kObj.Joints.Count; k++)
                            {
                                ShowArray("A" + (k + 1), kObj.Joints[k].GetArray());
                            }
                            Console.WriteLine("Press any key to continue...");
                            Console.ReadKey();
                        }
                        break;
                    case 4:
                        if (display)
                        {
                            Console.Clear();
                            double[,] results = kObj.CalculateKinematics();
                            ShowArray("The result T(" + 0 + "," + kObj.NumberOfJoints + ") is", results);
                            Console.WriteLine("\nThe position of the end effector is: (" + String.Format("{0:0.000}", results[0, 3]) + ", " + String.Format("{0:0.000}", results[1, 3]) + ", " + String.Format("{0:0.000}", results[2, 3]) + ")");
                            ShowArray("\nThe orientation of the end effector is", results, 3, 3);
                            Console.WriteLine("Press any key to continue...");
                            Console.ReadKey();
                        }
                        break;
                }
            }
        }

        public static int ShowMenu()
        {
            int selection = -1;
            Console.Clear();
            string menu = @"[1] New Calculation for PUMA 560.
[2] New Calculation for custom (Determine the size)
[3] Display the Matrices
[4] Result T
[5] Exit
----------------------------------------
Please enter your choice: ";
            while (selection < 0 || selection > 6)
            {
                Console.Clear();
                Console.Write(menu);
                string input = Console.ReadLine();
                Int32.TryParse(input, out selection);
            }
            return selection;
        }

        public static JointObject GetDHPatameter(int counter)
        {
            Console.WriteLine("\nEnter the joint" + counter + " parameters: ");
            JointObject linkObj = new JointObject();
            linkObj.Alpha = GetDouble(" " + Convert.ToChar(945) + counter + " : ");
            linkObj.A = GetDouble(" a" + counter + " : ");
            linkObj.Theta = GetDouble(" @" + counter + " : ");
            linkObj.D = GetDouble(" d" + counter + " : ");
            return linkObj;
        }

        public static double GetDouble(string message)
        {
            double d = Double.PositiveInfinity;
            while (Double.IsPositiveInfinity(d))
            {
                Console.Write(message);
                string s = Console.ReadLine();
                if (!Double.TryParse(s, out d))
                {
                    d = Double.PositiveInfinity;
                    Console.WriteLine(s + " is not a valid value!");
                }
            }
            return d;
        }

        public static void ShowArray(string title, double[,] array, int upperBound1, int upperBound2)
        {
            upperBound1 = (upperBound1 <= array.GetLength(0)) ? upperBound1 : array.GetLength(0);
            upperBound2 = (upperBound2 <= array.GetLength(1)) ? upperBound2 : array.GetLength(1);
            Console.WriteLine(title);
            Console.WriteLine("----------------------------------------");
            for (int i = 0; i < upperBound1; i++)
            {
                for (int j = 0; j < upperBound2; j++)
                {
                    Console.Write(String.Format("{0:0.##}", array[i, j]) + "\t");
                }
                Console.WriteLine();
            }
            Console.WriteLine("----------------------------------------");
        }

        public static void ShowArray(string title, double[,] array)
        {
            ShowArray(title, array, array.GetLength(0), array.GetLength(1));
        }
    }
}
